/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationDetails;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;

public interface ProjectsWithConfigurations<P extends ProjectDetails, C extends ConfigurationDetails> {
    public Set<P> getProjects();

    public Iterable<C> getConfigurationsFor(P var1);

    public static <P extends ProjectDetails, C extends ConfigurationDetails> ProjectsWithConfigurations<P, C> from(Iterable<Project> projects, Function<Project, P> projectProjector, Function<Project, Stream<? extends C>> configurationProjector) {
        final LinkedHashMap details = new LinkedHashMap();
        projects.forEach(p -> {
            ProjectDetails projectDetails = (ProjectDetails)projectProjector.apply((Project)p);
            Iterable configurationDetails = ((Stream)configurationProjector.apply((Project)p)).collect(Collectors.toList());
            details.put(projectDetails, configurationDetails);
        });
        return new ProjectsWithConfigurations<P, C>(){

            @Override
            public Set<P> getProjects() {
                return details.keySet();
            }

            @Override
            public Iterable<C> getConfigurationsFor(P project) {
                return details.getOrDefault(project, Collections.emptySet());
            }
        };
    }
}

