/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.jvm.JavaVersionParser;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.provider.MergeProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.tasks.compile.HasCompileOptions;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JavaPluginExtensionInternal;
import org.gradle.api.plugins.jvm.internal.DefaultJvmLanguageSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.JvmLanguageSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.JvmLanguageUtilities;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.InstanceGenerator;

public class DefaultJvmLanguageUtilities
implements JvmLanguageUtilities {
    private final ProjectInternal project;
    private final InstanceGenerator instanceGenerator;
    private final Map<ConfigurationInternal, Set<TaskProvider<?>>> configurationToCompileTasks;

    @Inject
    public DefaultJvmLanguageUtilities(InstanceGenerator instanceGenerator, ProjectInternal project) {
        this.instanceGenerator = instanceGenerator;
        this.project = project;
        this.configurationToCompileTasks = new HashMap(5);
    }

    public <COMPILE extends AbstractCompile> void useDefaultTargetPlatformInference(Configuration configuration, TaskProvider<COMPILE> compileTask) {
        ConfigurationInternal configurationInternal = (ConfigurationInternal)configuration;
        Set untypedTasks = this.configurationToCompileTasks.computeIfAbsent(configurationInternal, key -> new HashSet());
        Set compileTasks = (Set)Cast.uncheckedCast((Object)untypedTasks);
        compileTasks.add(compileTask);
        JavaPluginExtension java = (JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class);
        Provider targetJvmVersion = ((JavaPluginExtensionInternal)java).getAutoTargetJvm().flatMap(autoTargetJvm -> {
            if (!autoTargetJvm.booleanValue() && !configuration.isCanBeConsumed()) {
                return Providers.of((Object)Integer.MAX_VALUE);
            }
            return DefaultJvmLanguageUtilities.getMaxTargetJvmVersion(compileTasks);
        });
        configurationInternal.getAttributes().attributeProvider(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, targetJvmVersion);
    }

    public void registerJvmLanguageSourceDirectory(SourceSet sourceSet, String name, Action<? super JvmLanguageSourceDirectoryBuilder> configuration) {
        DefaultJvmLanguageSourceDirectoryBuilder builder = (DefaultJvmLanguageSourceDirectoryBuilder)this.instanceGenerator.newInstance(DefaultJvmLanguageSourceDirectoryBuilder.class, new Object[]{name, this.project, sourceSet});
        configuration.execute((Object)builder);
        builder.build();
    }

    private static <COMPILE extends AbstractCompile> ProviderInternal<Integer> getMaxTargetJvmVersion(Set<TaskProvider<COMPILE>> compileTasks) {
        assert (!compileTasks.isEmpty());
        List allTargetJdkVersions = compileTasks.stream().map(taskProvider -> taskProvider.flatMap(compileTask -> {
            if (((HasCompileOptions)compileTask).getOptions().getRelease().isPresent()) {
                return ((HasCompileOptions)compileTask).getOptions().getRelease();
            }
            List compilerArgs = ((HasCompileOptions)compileTask).getOptions().getCompilerArgs();
            int flagIndex = compilerArgs.indexOf("--release");
            if (flagIndex != -1 && flagIndex + 1 < compilerArgs.size()) {
                return Providers.of((Object)Integer.parseInt(String.valueOf(compilerArgs.get(flagIndex + 1))));
            }
            return Providers.of((Object)JavaVersionParser.parseMajorVersion((String)compileTask.getTargetCompatibility()));
        })).collect(Collectors.toList());
        return new MergeProvider(allTargetJdkVersions).map(Collections::max);
    }
}

