/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ComponentModuleMetadataHandlerInternal;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.LegacyResolutionParameters;
import org.gradle.api.internal.artifacts.RepositoriesSupplier;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.ImmutableModuleReplacements;
import org.gradle.api.internal.artifacts.ivyservice.ResolutionParameters;
import org.gradle.api.internal.artifacts.ivyservice.ShortCircuitingResolutionExecutor;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.AdhocRootComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ProjectRootComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalVariantGraphResolveStateBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.Conflict;
import org.gradle.api.internal.artifacts.repositories.ContentFilteringRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchemaFactory;
import org.gradle.api.internal.attributes.immutable.artifact.ImmutableArtifactTypeRegistry;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveStateFactory;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public class DefaultConfigurationResolver
implements ConfigurationResolver {
    private final RepositoriesSupplier repositoriesSupplier;
    private final ShortCircuitingResolutionExecutor resolutionExecutor;
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final ComponentModuleMetadataHandlerInternal componentModuleMetadataHandler;
    private final AttributeSchemaServices attributeSchemaServices;
    private final LocalVariantGraphResolveStateBuilder variantStateBuilder;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final RootComponentProvider rootComponentProvider;

    public DefaultConfigurationResolver(RepositoriesSupplier repositoriesSupplier, ShortCircuitingResolutionExecutor resolutionExecutor, ArtifactTypeRegistry artifactTypeRegistry, ComponentModuleMetadataHandlerInternal componentModuleMetadataHandler, AttributeSchemaServices attributeSchemaServices, LocalVariantGraphResolveStateBuilder variantStateBuilder, CalculatedValueContainerFactory calculatedValueContainerFactory, RootComponentProvider rootComponentProvider) {
        this.repositoriesSupplier = repositoriesSupplier;
        this.resolutionExecutor = resolutionExecutor;
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.componentModuleMetadataHandler = componentModuleMetadataHandler;
        this.attributeSchemaServices = attributeSchemaServices;
        this.variantStateBuilder = variantStateBuilder;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.rootComponentProvider = rootComponentProvider;
    }

    @Override
    public ResolverResults resolveBuildDependencies(ConfigurationInternal configuration, CalculatedValue<ResolverResults> futureCompleteResults) {
        LocalComponentGraphResolveState rootComponent = this.rootComponentProvider.getRootComponent(configuration.isDetachedConfiguration());
        LocalVariantGraphResolveState rootVariant = this.asRootVariant(configuration, rootComponent.getId());
        ResolutionParameters params = this.getResolutionParameters(configuration, rootComponent, rootVariant, false);
        ConfigurationLegacyResolutionParameters legacyParams = new ConfigurationLegacyResolutionParameters(configuration.getResolutionStrategy());
        return this.resolutionExecutor.resolveBuildDependencies(legacyParams, params, futureCompleteResults);
    }

    @Override
    public ResolverResults resolveGraph(ConfigurationInternal configuration) {
        LocalComponentGraphResolveState rootComponent = this.rootComponentProvider.getRootComponent(configuration.isDetachedConfiguration());
        LocalVariantGraphResolveState rootVariant = this.asRootVariant(configuration, rootComponent.getId());
        ImmutableAttributes attributes = rootVariant.getAttributes();
        List<ResolutionAwareRepository> filteredRepositories = ((List)this.repositoriesSupplier.get()).stream().filter(arg_0 -> DefaultConfigurationResolver.lambda$resolveGraph$0(configuration, (AttributeContainerInternal)attributes, arg_0)).collect(Collectors.toList());
        ResolutionParameters params = this.getResolutionParameters(configuration, rootComponent, rootVariant, true);
        ConfigurationLegacyResolutionParameters legacyParams = new ConfigurationLegacyResolutionParameters(configuration.getResolutionStrategy());
        return this.resolutionExecutor.resolveGraph(legacyParams, params, filteredRepositories);
    }

    private LocalVariantGraphResolveState asRootVariant(ConfigurationInternal configuration, ComponentIdentifier componentId) {
        return this.variantStateBuilder.createRootVariantState(configuration, componentId, new LocalVariantGraphResolveStateBuilder.DependencyCache(), configuration.getDomainObjectContext().getModel(), this.calculatedValueContainerFactory);
    }

    @Override
    public List<ResolutionAwareRepository> getAllRepositories() {
        return (List)this.repositoriesSupplier.get();
    }

    private ResolutionParameters getResolutionParameters(ConfigurationInternal configuration, LocalComponentGraphResolveState rootComponent, LocalVariantGraphResolveState rootVariant, boolean includeConsistentResolutionLocks) {
        ResolutionStrategyInternal resolutionStrategy = configuration.getResolutionStrategy();
        ImmutableList<ResolutionParameters.ModuleVersionLock> moduleVersionLocks = includeConsistentResolutionLocks ? configuration.getConsistentResolutionVersionLocks() : ImmutableList.of();
        ImmutableArtifactTypeRegistry immutableArtifactTypeRegistry = this.attributeSchemaServices.getArtifactTypeRegistryFactory().create(this.artifactTypeRegistry);
        ImmutableModuleReplacements moduleReplacements = this.componentModuleMetadataHandler.getModuleReplacements();
        ConfigurationFailureResolutions failureResolutions = new ConfigurationFailureResolutions(configuration.getDomainObjectContext().getProjectIdentity(), configuration.getName());
        return new ResolutionParameters(configuration.getResolutionHost(), rootComponent, rootVariant, moduleVersionLocks, resolutionStrategy.getSortOrder(), configuration.getConfigurationIdentity(), immutableArtifactTypeRegistry, moduleReplacements, resolutionStrategy.getConflictResolution(), configuration.getName(), resolutionStrategy.isDependencyLockingEnabled(), resolutionStrategy.getIncludeAllSelectableVariantResults(), resolutionStrategy.isDependencyVerificationEnabled(), resolutionStrategy.isFailingOnDynamicVersions(), resolutionStrategy.isFailingOnChangingVersions(), failureResolutions, resolutionStrategy.getCachePolicy().asImmutable());
    }

    private static boolean shouldSkipRepository(ResolutionAwareRepository repository, String configurationName, AttributeContainer consumerAttributes) {
        if (!(repository instanceof ContentFilteringRepository)) {
            return false;
        }
        ContentFilteringRepository cfr = (ContentFilteringRepository)((Object)repository);
        Set<String> includedConfigurations = cfr.getIncludedConfigurations();
        Set<String> excludedConfigurations = cfr.getExcludedConfigurations();
        if (includedConfigurations != null && !includedConfigurations.contains(configurationName) || excludedConfigurations != null && excludedConfigurations.contains(configurationName)) {
            return true;
        }
        Map<Attribute<Object>, Set<Object>> requiredAttributes = cfr.getRequiredAttributes();
        return DefaultConfigurationResolver.hasNonRequiredAttribute(requiredAttributes, consumerAttributes);
    }

    private static boolean hasNonRequiredAttribute(@Nullable Map<Attribute<Object>, Set<Object>> requiredAttributes, AttributeContainer consumerAttributes) {
        if (requiredAttributes == null) {
            return false;
        }
        for (Map.Entry<Attribute<Object>, Set<Object>> entry : requiredAttributes.entrySet()) {
            Object value;
            Attribute<Object> key = entry.getKey();
            Set<Object> allowedValues = entry.getValue();
            if (allowedValues.contains(value = consumerAttributes.getAttribute(key))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$resolveGraph$0(ConfigurationInternal configuration, AttributeContainerInternal attributes, ResolutionAwareRepository repository) {
        return !DefaultConfigurationResolver.shouldSkipRepository(repository, configuration.getName(), (AttributeContainer)attributes);
    }

    private static class ConfigurationLegacyResolutionParameters
    implements LegacyResolutionParameters {
        private final ResolutionStrategyInternal resolutionStrategy;

        public ConfigurationLegacyResolutionParameters(ResolutionStrategyInternal resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
        }

        @Override
        public ImmutableActionSet<DependencySubstitutionInternal> getDependencySubstitutionRules() {
            return this.resolutionStrategy.getDependencySubstitutionRule();
        }

        @Override
        public CapabilitiesResolutionInternal getCapabilityConflictResolutionRules() {
            return this.resolutionStrategy.getCapabilitiesResolutionRules();
        }

        @Override
        public ComponentSelectionRulesInternal getComponentSelectionRules() {
            return this.resolutionStrategy.getComponentSelection();
        }
    }

    private static class ConfigurationFailureResolutions
    implements ResolutionParameters.FailureResolutions {
        private final @Nullable ProjectIdentity owningProject;
        private final String configurationName;

        public ConfigurationFailureResolutions(@Nullable ProjectIdentity owningProject, String configurationName) {
            this.owningProject = owningProject;
            this.configurationName = configurationName;
        }

        @Override
        public List<String> forVersionConflict(Conflict conflict) {
            if (this.owningProject == null) {
                return Collections.emptyList();
            }
            String taskPath = this.owningProject.getBuildTreePath().append(Path.path((String)"dependencyInsight")).asString();
            ModuleIdentifier moduleId = conflict.getModuleId();
            String dependencyNotation = moduleId.getGroup() + ":" + moduleId.getName();
            return Collections.singletonList(String.format("Run with %s --configuration %s --dependency %s to get more insight on how to solve the conflict.", taskPath, this.configurationName, dependencyNotation));
        }
    }

    public static class Factory
    implements ConfigurationResolver.Factory {
        private final DependencyMetaDataProvider moduleIdentity;
        private final RepositoriesSupplier repositoriesSupplier;
        private final ShortCircuitingResolutionExecutor resolutionExecutor;
        private final ArtifactTypeRegistry artifactTypeRegistry;
        private final ComponentModuleMetadataHandlerInternal componentModuleMetadataHandler;
        private final AttributeSchemaServices attributeSchemaServices;
        private final LocalVariantGraphResolveStateBuilder variantStateBuilder;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private final ImmutableAttributesSchemaFactory attributesSchemaFactory;
        private final LocalComponentGraphResolveStateFactory localResolveStateFactory;

        public Factory(DependencyMetaDataProvider moduleIdentity, RepositoriesSupplier repositoriesSupplier, ShortCircuitingResolutionExecutor resolutionExecutor, ArtifactTypeRegistry artifactTypeRegistry, ComponentModuleMetadataHandlerInternal componentModuleMetadataHandler, AttributeSchemaServices attributeSchemaServices, LocalVariantGraphResolveStateBuilder variantStateBuilder, CalculatedValueContainerFactory calculatedValueContainerFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, ImmutableAttributesSchemaFactory attributesSchemaFactory, LocalComponentGraphResolveStateFactory localResolveStateFactory) {
            this.moduleIdentity = moduleIdentity;
            this.repositoriesSupplier = repositoriesSupplier;
            this.resolutionExecutor = resolutionExecutor;
            this.artifactTypeRegistry = artifactTypeRegistry;
            this.componentModuleMetadataHandler = componentModuleMetadataHandler;
            this.attributeSchemaServices = attributeSchemaServices;
            this.variantStateBuilder = variantStateBuilder;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
            this.moduleIdentifierFactory = moduleIdentifierFactory;
            this.attributesSchemaFactory = attributesSchemaFactory;
            this.localResolveStateFactory = localResolveStateFactory;
        }

        @Override
        public ConfigurationResolver create(ConfigurationsProvider configurations, DomainObjectContext owner, AttributesSchemaInternal schema) {
            RootComponentProvider rootComponentProvider = this.createRootComponentProvider(configurations, owner, schema);
            return new DefaultConfigurationResolver(this.repositoriesSupplier, this.resolutionExecutor, this.artifactTypeRegistry, this.componentModuleMetadataHandler, this.attributeSchemaServices, this.variantStateBuilder, this.calculatedValueContainerFactory, rootComponentProvider);
        }

        private RootComponentProvider createRootComponentProvider(ConfigurationsProvider configurations, DomainObjectContext owner, AttributesSchemaInternal schema) {
            AdhocRootComponentProvider adhocRootComponentProvider = new AdhocRootComponentProvider(schema, this.moduleIdentifierFactory, this.attributesSchemaFactory, this.localResolveStateFactory);
            if (owner.getProjectIdentity() == null) {
                return adhocRootComponentProvider;
            }
            return new ProjectRootComponentProvider(owner.getProject().getOwner(), this.moduleIdentity, schema, configurations, this.moduleIdentifierFactory, this.localResolveStateFactory, this.attributesSchemaFactory, adhocRootComponentProvider);
        }
    }
}

