/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.pom;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.platform.backend.navigation.NavigationRequest;
import org.jetbrains.kotlin.com.intellij.platform.backend.navigation.NavigationRequests;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.concurrency.ThreadingAssertions;

public interface Navigatable {
    public static final Navigatable[] EMPTY_NAVIGATABLE_ARRAY = new Navigatable[0];

    @ApiStatus.Experimental
    @Nullable
    default public NavigationRequest navigationRequest() {
        ThreadingAssertions.assertBackgroundThread();
        return NavigationRequests.getInstance().rawNavigationRequest(this);
    }

    default public void navigate(boolean requestFocus) {
        throw new IncorrectOperationException("Must not call `navigate(boolean)` if `canNavigate()` returns `false`, or `navigate(boolean)` should be overridden if `canNavigate()` can return `true`.");
    }

    default public boolean canNavigate() {
        return false;
    }

    default public boolean canNavigateToSource() {
        return false;
    }
}

