/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class GofishPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.GofishPackager, GofishPackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private static final long serialVersionUID = -4053286282850852250L;
    private final GofishRepository repository = new GofishRepository();
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.GofishPackager immutable = new org.jreleaser.model.api.packagers.GofishPackager(){
        private static final long serialVersionUID = 5164825472096915255L;

        public org.jreleaser.model.api.packagers.PackagerRepository getRepository() {
            return GofishPackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public CommitAuthor getCommitAuthor() {
            return GofishPackager.this.getCommitAuthor().asImmutable();
        }

        public String getTemplateDirectory() {
            return GofishPackager.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(GofishPackager.this.getSkipTemplates());
        }

        public String getType() {
            return GofishPackager.this.getType();
        }

        public String getDownloadUrl() {
            return GofishPackager.this.getDownloadUrl();
        }

        public boolean supportsPlatform(String platform) {
            return GofishPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return GofishPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return GofishPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return GofishPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return GofishPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return GofishPackager.this.isContinueOnError();
        }

        public boolean isSkipPublishing() {
            return GofishPackager.this.isSkipPublishing();
        }

        public Active getActive() {
            return GofishPackager.this.getActive();
        }

        public boolean isEnabled() {
            return GofishPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(GofishPackager.this.asMap(full));
        }

        public String getPrefix() {
            return GofishPackager.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(GofishPackager.this.getExtraProperties());
        }
    };

    public GofishPackager() {
        super("gofish");
    }

    @Override
    public org.jreleaser.model.api.packagers.GofishPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(GofishPackager source) {
        super.merge(source);
        this.setRepository(source.repository);
    }

    public GofishRepository getRepository() {
        return this.repository;
    }

    public void setRepository(GofishRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getPackagerRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.getRepository();
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform) || PlatformUtils.isWindows((String)platform) || PlatformUtils.isLinux((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipGofish"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension(), FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
    }

    public static final class GofishRepository
    extends PackagerRepository {
        private static final long serialVersionUID = 2534363121328369670L;

        public GofishRepository() {
            super("gofish", "fish-food");
        }
    }
}

