/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.JReleaserOutput;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.packagers.AbstractRepositoryPackager;
import org.jreleaser.model.internal.packagers.PackagerRepository;
import org.jreleaser.model.internal.packagers.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class ScoopPackager
extends AbstractRepositoryPackager<org.jreleaser.model.api.packagers.ScoopPackager, ScoopPackager> {
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private static final long serialVersionUID = 7277751575218470373L;
    private final ScoopRepository repository = new ScoopRepository();
    private String packageName;
    private String checkverUrl;
    private String autoupdateUrl;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.ScoopPackager immutable = new org.jreleaser.model.api.packagers.ScoopPackager(){
        private static final long serialVersionUID = -6453585021321457904L;

        public String getPackageName() {
            return ScoopPackager.this.packageName;
        }

        public String getCheckverUrl() {
            return ScoopPackager.this.checkverUrl;
        }

        public String getAutoupdateUrl() {
            return ScoopPackager.this.autoupdateUrl;
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getRepository() {
            return ScoopPackager.this.repository.asImmutable();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getBucket() {
            return this.getRepository();
        }

        public org.jreleaser.model.api.packagers.PackagerRepository getPackagerRepository() {
            return this.getRepository();
        }

        public CommitAuthor getCommitAuthor() {
            return ScoopPackager.this.getCommitAuthor().asImmutable();
        }

        public String getTemplateDirectory() {
            return ScoopPackager.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(ScoopPackager.this.getSkipTemplates());
        }

        public String getType() {
            return ScoopPackager.this.getType();
        }

        public String getDownloadUrl() {
            return ScoopPackager.this.getDownloadUrl();
        }

        public boolean supportsPlatform(String platform) {
            return ScoopPackager.this.supportsPlatform(platform);
        }

        public boolean supportsDistribution(Distribution.DistributionType distributionType) {
            return ScoopPackager.this.supportsDistribution(distributionType);
        }

        public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
            return ScoopPackager.this.getSupportedFileExtensions(distributionType);
        }

        public Set<Stereotype> getSupportedStereotypes() {
            return ScoopPackager.this.getSupportedStereotypes();
        }

        public boolean isSnapshotSupported() {
            return ScoopPackager.this.isSnapshotSupported();
        }

        public boolean isContinueOnError() {
            return ScoopPackager.this.isContinueOnError();
        }

        public boolean isSkipPublishing() {
            return ScoopPackager.this.isSkipPublishing();
        }

        public Active getActive() {
            return ScoopPackager.this.getActive();
        }

        public boolean isEnabled() {
            return ScoopPackager.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(ScoopPackager.this.asMap(full));
        }

        public String getPrefix() {
            return ScoopPackager.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(ScoopPackager.this.getExtraProperties());
        }
    };

    public ScoopPackager() {
        super("scoop");
    }

    @Override
    public org.jreleaser.model.api.packagers.ScoopPackager asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(ScoopPackager source) {
        super.merge(source);
        this.packageName = this.merge(this.packageName, source.packageName);
        this.checkverUrl = this.merge(this.checkverUrl, source.checkverUrl);
        this.autoupdateUrl = this.merge(this.autoupdateUrl, source.autoupdateUrl);
        this.setRepository(source.repository);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getCheckverUrl() {
        return this.checkverUrl;
    }

    public void setCheckverUrl(String checkverUrl) {
        this.checkverUrl = checkverUrl;
    }

    public String getAutoupdateUrl() {
        return this.autoupdateUrl;
    }

    public void setAutoupdateUrl(String autoupdateUrl) {
        this.autoupdateUrl = autoupdateUrl;
    }

    public ScoopRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ScoopRepository repository) {
        this.repository.merge(repository);
    }

    @Deprecated
    public ScoopRepository getBucket() {
        return this.getRepository();
    }

    @Deprecated
    public void setBucket(ScoopRepository repository) {
        JReleaserOutput.nag((String)"scoop.bucket is deprecated since 1.8.0 and will be removed in 2.0.0. Use scoop.repository instead");
        this.setRepository(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("checkverUrl", this.checkverUrl);
        props.put("autoupdateUrl", this.autoupdateUrl);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.getRepository();
    }

    public PackagerRepository getPackagerRepository() {
        return this.getRepository();
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isWindows((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution.DistributionType distributionType) {
        return SUPPORTED.containsKey(distributionType);
    }

    @Override
    public Set<String> getSupportedFileExtensions(Distribution.DistributionType distributionType) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault(distributionType, Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get("skipScoop"));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_PACKAGE, CollectionUtils.setOf((Object[])new String[]{FileType.MSI.extension()}));
        SUPPORTED.put(Distribution.DistributionType.SINGLE_JAR, CollectionUtils.setOf((Object[])new String[]{FileType.JAR.extension()}));
        SUPPORTED.put(Distribution.DistributionType.FLAT_BINARY, CollectionUtils.setOf((Object[])new String[]{FileType.BAT.extension(), FileType.CMD.extension(), FileType.EXE.extension(), FileType.PS1.extension()}));
    }

    public static final class ScoopRepository
    extends PackagerRepository {
        private static final long serialVersionUID = 5693815301518572010L;

        public ScoopRepository() {
            super("scoop", "scoop");
        }
    }
}

