/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import java.util.LinkedList;

public abstract class AbstractSuperCheck
extends Check {
    private final LinkedList mMethodStack = new LinkedList();

    public int[] getDefaultTokens() {
        return new int[]{9, 79};
    }

    protected abstract String getMethodName();

    public void beginTree(DetailAST aRootAST) {
        this.mMethodStack.clear();
    }

    public void visitToken(DetailAST aAST) {
        if (this.isOverridingMethod(aAST)) {
            this.mMethodStack.add(new MethodNode(aAST));
        } else if (this.isSuperCall(aAST)) {
            MethodNode methodNode = (MethodNode)this.mMethodStack.getLast();
            methodNode.setCallsSuper();
        }
    }

    private boolean isSuperCall(DetailAST aAST) {
        if (aAST.getType() != 79) {
            return false;
        }
        DetailAST parent = aAST.getParent();
        if (parent == null || parent.getType() != 59) {
            return false;
        }
        AST sibling = aAST.getNextSibling();
        if (sibling != null && sibling.getType() == 163) {
            sibling = sibling.getNextSibling();
        }
        if (sibling == null || sibling.getType() != 58) {
            return false;
        }
        String name = sibling.getText();
        if (!this.getMethodName().equals(name)) {
            return false;
        }
        DetailAST args = (DetailAST)parent.getNextSibling();
        if (args == null || args.getType() != 34) {
            return false;
        }
        if (args.getChildCount() != 0) {
            return false;
        }
        while (parent != null) {
            if (parent.getType() == 9) {
                return this.isOverridingMethod(parent);
            }
            if (parent.getType() == 8 || parent.getType() == 11) {
                return false;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public void leaveToken(DetailAST aAST) {
        MethodNode methodNode;
        if (this.isOverridingMethod(aAST) && !(methodNode = (MethodNode)this.mMethodStack.removeLast()).getCallsSuper()) {
            DetailAST methodAST = methodNode.getMethod();
            DetailAST nameAST = methodAST.findFirstToken(58);
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), "missing.super.call", new Object[]{nameAST.getText()});
        }
    }

    private boolean isOverridingMethod(DetailAST aAST) {
        if (aAST.getType() != 9 || ScopeUtils.inInterfaceOrAnnotationBlock(aAST)) {
            return false;
        }
        DetailAST nameAST = aAST.findFirstToken(58);
        String name = nameAST.getText();
        if (!this.getMethodName().equals(name)) {
            return false;
        }
        DetailAST params = aAST.findFirstToken(20);
        return params.getChildCount() == 0;
    }

    private class MethodNode {
        private DetailAST mMethod;
        private boolean mCallsSuper;

        public MethodNode(DetailAST aAST) {
            this.mMethod = aAST;
            this.mCallsSuper = false;
        }

        public void setCallsSuper() {
            this.mCallsSuper = true;
        }

        public boolean getCallsSuper() {
            return this.mCallsSuper;
        }

        public DetailAST getMethod() {
            return this.mMethod;
        }
    }
}

