/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class HiddenFieldCheck
extends Check {
    private FieldFrame mCurrentFrame;
    private Pattern mRegexp;
    private boolean mIgnoreSetter;
    private boolean mIgnoreConstructorParameter;
    private boolean mIgnoreAbstractMethods;

    public int[] getDefaultTokens() {
        return new int[]{10, 21, 14, 154, 155};
    }

    public int[] getAcceptableTokens() {
        return new int[]{10, 21};
    }

    public int[] getRequiredTokens() {
        return new int[]{14, 154, 155};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mCurrentFrame = new FieldFrame(null, true);
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 10 || aAST.getType() == 21) {
            this.processVariable(aAST);
            return;
        }
        DetailAST typeMods = aAST.findFirstToken(5);
        boolean isStaticInnerType = typeMods != null && typeMods.branchContains(64);
        FieldFrame frame = new FieldFrame(this.mCurrentFrame, isStaticInnerType);
        DetailAST objBlock = aAST.findFirstToken(6);
        if (objBlock != null) {
            for (DetailAST child = (DetailAST)objBlock.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                if (child.getType() != 10) continue;
                String name = child.findFirstToken(58).getText();
                DetailAST mods = child.findFirstToken(5);
                if (mods.branchContains(64)) {
                    frame.addStaticField(name);
                    continue;
                }
                frame.addInstanceField(name);
            }
        }
        this.mCurrentFrame = frame;
    }

    public void leaveToken(DetailAST aAST) {
        if (aAST.getType() == 14 || aAST.getType() == 154 || aAST.getType() == 155) {
            this.mCurrentFrame = this.mCurrentFrame.getParent();
        }
    }

    private void processVariable(DetailAST aAST) {
        if (ScopeUtils.inInterfaceOrAnnotationBlock(aAST) || !ScopeUtils.isLocalVariableDef(aAST) && aAST.getType() != 21) {
            return;
        }
        DetailAST nameAST = aAST.findFirstToken(58);
        String name = nameAST.getText();
        if (!(!this.mCurrentFrame.containsStaticField(name) && (HiddenFieldCheck.inStatic(aAST) || !this.mCurrentFrame.containsInstanceField(name)) || this.mRegexp != null && this.getRegexp().matcher(name).find() || this.isIgnoredSetterParam(aAST, name) || this.isIgnoredConstructorParam(aAST) || this.isIgnoredParamOfAbstractMethod(aAST))) {
            this.log(nameAST, "hidden.field", (Object)name);
        }
    }

    private static boolean inStatic(DetailAST aAST) {
        for (DetailAST parent = aAST.getParent(); parent != null; parent = parent.getParent()) {
            switch (parent.getType()) {
                case 12: {
                    return true;
                }
                case 9: {
                    DetailAST mods = parent.findFirstToken(5);
                    return mods.branchContains(64);
                }
            }
        }
        return false;
    }

    private boolean isIgnoredSetterParam(DetailAST aAST, String aName) {
        if (aAST.getType() != 21 || !this.mIgnoreSetter) {
            return false;
        }
        DetailAST parametersAST = aAST.getParent();
        if (parametersAST.getChildCount() != 1) {
            return false;
        }
        DetailAST methodAST = parametersAST.getParent();
        if (methodAST.getType() != 9) {
            return false;
        }
        String expectedName = "set" + aName.substring(0, 1).toUpperCase() + aName.substring(1);
        DetailAST methodNameAST = methodAST.findFirstToken(58);
        String methodName = methodNameAST.getText();
        if (!methodName.equals(expectedName)) {
            return false;
        }
        DetailAST typeAST = methodAST.findFirstToken(13);
        return typeAST.branchContains(49);
    }

    private boolean isIgnoredConstructorParam(DetailAST aAST) {
        if (aAST.getType() != 21 || !this.mIgnoreConstructorParameter) {
            return false;
        }
        DetailAST parametersAST = aAST.getParent();
        DetailAST constructorAST = parametersAST.getParent();
        return constructorAST.getType() == 8;
    }

    private boolean isIgnoredParamOfAbstractMethod(DetailAST aAST) {
        if (aAST.getType() != 21 || !this.mIgnoreAbstractMethods) {
            return false;
        }
        DetailAST method = aAST.getParent().getParent();
        if (method.getType() != 9) {
            return false;
        }
        DetailAST mods = method.findFirstToken(5);
        return mods != null && mods.branchContains(40);
    }

    public void setIgnoreFormat(String aFormat) throws ConversionException {
        try {
            this.mRegexp = Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, e);
        }
    }

    public void setIgnoreSetter(boolean aIgnoreSetter) {
        this.mIgnoreSetter = aIgnoreSetter;
    }

    public void setIgnoreConstructorParameter(boolean aIgnoreConstructorParameter) {
        this.mIgnoreConstructorParameter = aIgnoreConstructorParameter;
    }

    public void setIgnoreAbstractMethods(boolean aIgnoreAbstractMethods) {
        this.mIgnoreAbstractMethods = aIgnoreAbstractMethods;
    }

    public Pattern getRegexp() {
        return this.mRegexp;
    }

    private static class FieldFrame {
        private boolean mStaticType;
        private FieldFrame mParent;
        private final Set mInstanceFields = new HashSet();
        private final Set mStaticFields = new HashSet();

        public FieldFrame(FieldFrame aParent, boolean aStaticType) {
            this.mParent = aParent;
            this.mStaticType = aStaticType;
        }

        boolean isStaticType() {
            return this.mStaticType;
        }

        public void addInstanceField(String aField) {
            this.mInstanceFields.add(aField);
        }

        public void addStaticField(String aField) {
            this.mStaticFields.add(aField);
        }

        public boolean containsInstanceField(String aField) {
            if (this.mInstanceFields.contains(aField)) {
                return true;
            }
            if (this.mStaticType) {
                return false;
            }
            return this.mParent != null && this.mParent.containsInstanceField(aField);
        }

        public boolean containsStaticField(String aField) {
            if (this.mStaticFields.contains(aField)) {
                return true;
            }
            return this.mParent != null && this.mParent.containsStaticField(aField);
        }

        public FieldFrame getParent() {
            return this.mParent;
        }
    }
}

